unit Pzdspbut;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, PZBPanel, PZShaded, StdCtrls, PZLabel, PZSpButt;

type
  TPZSpeedButtonForm = class(TForm)
    HeaderPanel: TPZBitmapPanel;
    PZShaded1: TPZShaded;
    DescrPanel: TPZBitmapPanel;
    PZLabel4: TPZLabel;
    ResultsPanel: TPZBitmapPanel;
    PZLabel5: TPZLabel;
    PZLabel2: TPZLabel;
    OutputPanel1: TPZBitmapPanel;
    PZBitmapPanel1: TPZBitmapPanel;
    PZLabel1: TPZLabel;
    PZSpeedButton1: TPZSpeedButton;
    PZSpeedButton2: TPZSpeedButton;
    PZSpeedButton3: TPZSpeedButton;
    PZSpeedButton4: TPZSpeedButton;
    PZSpeedButton5: TPZSpeedButton;
    PZSpeedButton6: TPZSpeedButton;
    ClickedLabel: TPZLabel;
    ClickedTimer: TTimer;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure PZSpeedButtonClick(Sender: TObject);
    procedure ClickedTimerTimer(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PZSpeedButtonForm: TPZSpeedButtonForm;

implementation

Uses PZDMain;

{$R *.DFM}

procedure TPZSpeedButtonForm.FormCreate(Sender: TObject);

Begin
  SetBounds(10,10,MainForm.ClientWidth-20,MainForm.ClientHeight-MainForm.MainPanel.Height-20);
  HeaderPanel.Background.LoadBitmap('PZD_STONE');
  DescrPanel.Background.LoadBitmap('PZD_STONE');
  ResultsPanel.Background.LoadBitmap('PZD_STONE');
  OutputPanel1.Background.LoadBitmap('PZD_STONE');
End;

procedure TPZSpeedButtonForm.FormClose(Sender: TObject;  var Action: TCloseAction);

Begin
  Action:=caFree;
End;

procedure TPZSpeedButtonForm.PZSpeedButtonClick(Sender: TObject);
begin
  With Sender As TPZSpeedButton Do
    Begin
      ClickedLabel.Caption:='Button \cRed'+Copy(Caption,2,255)+'\cn clicked.';
      ClickedTimer.Enabled:=False;
      ClickedTimer.Enabled:=True;
    End;
end;

procedure TPZSpeedButtonForm.ClickedTimerTimer(Sender: TObject);
begin
  ClickedLabel.Caption:='';
  ClickedTimer.Enabled:=False;
end;

procedure TPZSpeedButtonForm.FormDeactivate(Sender: TObject);
begin
  Close;
end;

end.
